# Game Design Principles
This document is intended for contributors and may contain spoilers.

## What is Cubyz?
Cubyz is a voxel sandbox game with infinite world and focus on great adventures, immersive exploration with numerous challenges along the way. We cherish freedom and we are determined to give it to the players in abundance, so they can chose their own path through the world.

### Progression
We want to encourage interacting with different mechanics, such as exploring, building, crafting, and etc. Progression therefore encourages the player to interact with all of these systems.
Examples:
- Explore to Build: The player needs to interact with exploration to get the resources they want for building.
- Survive to Explore: Caves and structures may have enemies and traps that the player has to face if they want to explore in peace.
- Strategize to Survive: Prepare for a trip with tools, weapons, and gear in order to make survival easier.
- Build to Strategize: The player has to build defenses for events, invasions, and bosses. They also need to upgrade their workstations to allow for better gear.

## Break the Cycle
### No Dimensions
Instead of creating seperate dimensions, we can fit these places physically into Cubyz' massive world for the player to come across.

### No Teleportation
Teleportation makes the game less immersive, as it diminishes the exploring aspect and doesn't let the player get a good sense of the scale of the world.

### No Automation
Having quick, infinite resources at the palm of players' hands discourages exploration, as the player will never need to forage or search for blocks they desire.

### Mobs Don't Respawn Naturally
Clearing a dangerous area of its monsters will make it safe to build and explore.
This rule is also here to prevent mob farming.

### No Passive Animals
Animals do not want to die, so they will either run from an attacking player or attempt to defend themselves. The player will have to strategize to be able to hunt.

### No Unbreakable Tools
If a player gets too attached to their amazing tool, they won't want to make other types of tools, and low-tier materials will see less use as they will never be used in tool-making.

### Avoid Clutter
Inventories will often fill up with random items that the player does not want, making their inventory hard to manage. To mitigate this, find uses for existing items before adding new ones and prevent items from finding their way into a player's inventory when they don't want it.

### Use Realism Tastefully
Cubyz is not a realistic game. The world is very whimsical and has rules of its own, sometimes inspired by the real world, but never copied without a good reason.

### Avoid Excessive Additions
Unless there is a genuine functional reason for a variant or addition to be added, they should be avoided. Try to use or modify existing content first before creating new stuff.

## Player Engagement
### "How would the player feel?"
Put yourself in the shoes of a player encountering a mechanic for the first time and ask yourself this. The goal is to make the player feel how you want them to, whether that be satisfaction, fear, or intrigue.

### Depth in Simplicity
It's important to remember to keep the game approachable to new players, so appearing simple is key. However, what will keep a player around is the game's depth. Design mechanics around being simple on the surface, but have them able to be expanded upon, upgraded, or customized to meet the player's needs.

### Fuel the Player's Curiosity
Fill the world with secrets that will keep the player interested and engaged with exploration.

### Problems have Multiple Solutions
Problems faced in a particular age of progression should have multiple solutions, instead of just one solution for everything.
For example, in the "Pre-Caves Age," the player will not have access to coal, as coal spawns low in the world and is shrouded in darkness. There's many solutions to this, however:
- Find a dim, above ground light source.
- Search for a cave with exposed coal.
- Wander into the darkness to find a cave that's bright enough to mine in.
- Find an above-ground structure that can grant the player coal.
- Dig straight down until you find coal.

This problem is completely solved as soon as the player gets coal, as they can now explore caves to find more coal with their newfound torches. It's important that the player has these options to prevent them from getting stuck on a seemingly insurmountable barrier. This gives them more freedom in how they can approach the game, as no one option is particularly the best and can change depending on situation and location.

### Explain when Needed
Progress-related mechanics need explanations or subtle hints so players don't get stuck. Keep it simple on the surface so it's easily approachable, but leave out details that the player can find themselves through intuition.

### Embrace Micro Moments
These are tiny things the player does in between larger events; examples include:
- Travelling
- Parkour
- Mining
- Building
- Crafting
- Managing inventory
- Fighting

These moments are extremely important as they largely influence the player's mood, so making sure they're as satisfying and consistent as possible is a must.

### Make the World Feel Alive
To add immersion to the game, creatures should perform behaviors outside of player input, such as hunting, playing, migrating, eating, or sleeping.

## Balancing
When balancing the game, keep in mind how players might interact with the world, the wildlife, and each other.

### 2OP4ME
Players need to be vulnerable at all times to avoid power imbalances. Armor, tools, accessories, and buffs should aid the player, not let them win outright.

### Trade-offs
If the player is given something to aid them, then it should have an appropriate take-away to balance it.

**Examples:**
- Using rare resources to create a strong tool.
- An accessory that heals the player, but takes away energy or some other resource.
- Enemies have strengths and weaknesses towards particular damage types.

## Little Details

### Big Trees vs Small Trees
Big trees are designed to be built upon or left as decoration, whereas small trees are designed to be chopped down.

### Vegetation
Vegetation should fit the biome's climate. For example, Toadstools prefer humid areas, while Boletes prefer nutritious areas. Give some extra thought to the plants you place.

### Caves are Creepy and Mysterious
As the player descends into Cubyz, the music gets scarier, the monsters become more vicious and disturbing, and the cave generation becomes increasingly precarious. Outside of difficulty, this adds stress that the player needs to overcome to gain large rewards.
